{smcl}
{* *! version 5.2  20nov2025}{...}
{viewerjumpto "Syntax" "x13as##syntax"}{...}
{viewerjumpto "Description" "x13as##description"}{...}
{viewerjumpto "Options" "x13as##options"}{...}
{viewerjumpto "Examples" "x13as##examples"}{...}
{viewerjumpto "Stored results" "x13as##results"}{...}
{title:Title}

{phang}
{bf:x13as} {hline 2} Simplified seasonal adjustment using X-13ARIMA-SEATS


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:x13as}
{varname}
{ifin}
[{cmd:,} {it:options}]

{synoptset 20 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Main}
{synopt:{opt method(string)}}decomposition method: {bf:seats} (default) or {bf:x11}{p_end}
{synopt:{opt transform(string)}}transformation: {bf:auto} (default), {bf:none}, or {bf:log}{p_end}

{syntab:Output Variables}
{synopt:{opt saving(name)}}name for seasonally adjusted series (default: {it:varname}_sa){p_end}
{synopt:{opt trend(name)}}save trend-cycle component{p_end}
{synopt:{opt irregular(name)}}save irregular component{p_end}
{synopt:{opt sfactor(name)}}save seasonal factors{p_end}

{syntab:File Management}
{synopt:{opt workdir(string)}}directory for temporary files{p_end}
{synopt:{opt keepfiles}}preserve X-13 specification and output files{p_end}
{synopt:{opt replace}}replace existing variables{p_end}
{synopt:{opt details}}display X-13 specification and execution details{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{cmd:x13as} is a simplified Stata interface to the U.S. Census Bureau's
X-13ARIMA-SEATS seasonal adjustment program. This version provides four
pre-configured specifications that cover the most common use cases:

{phang2}1. {bf:SEATS with transform=auto (default)} - Model-based decomposition with
automatic transformation selection{p_end}

{phang2}2. {bf:X-11 with transform=auto} - X-11 decomposition with automatic
transformation selection{p_end}

{phang2}3. {bf:SEATS or X-11 with transform=none} - Decomposition without
transformation (additive){p_end}

{phang2}4. {bf:SEATS or X-11 with transform=log} - Decomposition with log
transformation (multiplicative){p_end}

{pstd}
The {bf:transform} option (auto/none/log) works with both SEATS and X-11 methods,
with {bf:auto} being the default. The {bf:method} option (seats/x11) determines
the decomposition algorithm, with {bf:seats} being the default.

{pstd}
All four specifications include:

{phang2}• Automatic ARIMA model selection via {bf:automdl}{p_end}
{phang2}• Automatic detection of trading day effects{p_end}
{phang2}• Automatic detection of Easter effects{p_end}
{phang2}• Automatic outlier detection{p_end}

{pstd}
{bf:Key features:}

{phang2}• Simple interface with sensible defaults{p_end}
{phang2}• Automatic frequency detection (monthly or quarterly){p_end}
{phang2}• Automatic model identification{p_end}
{phang2}• Calendar effect testing{p_end}
{phang2}• Automatic outlier detection and adjustment{p_end}
{phang2}• Clean temporary file management{p_end}


{marker options}{...}
{title:Options}

{dlgtab:Main}

{phang}
{opt method(string)} specifies the decomposition method. Options are:

{phang2}{bf:seats} - SEATS (Signal Extraction in ARIMA Time Series) decomposition.
This is a model-based method that derives components from the fitted ARIMA model.
Uses {bf:noadmiss=yes} to ensure proper decomposition. This is the default.{p_end}

{phang2}{bf:x11} - X-11 decomposition using moving averages and filters.
This is a non-parametric method.{p_end}

{phang}
{opt transform(string)} specifies the transformation to apply before decomposition.
This option applies to both SEATS and X-11 methods. Options are:

{phang2}{bf:auto} - Let X-13 automatically determine whether to use log
transformation based on the data. This is the default for both SEATS and X-11.{p_end}

{phang2}{bf:none} - No transformation (additive decomposition). Use when the
series can have negative values or when variance is stable.{p_end}

{phang2}{bf:log} - Log transformation (multiplicative decomposition). Use when
variance increases with the level of the series.{p_end}

{phang}
Note: Both SEATS and X-11 support all three transformation options. When
{opt transform(auto)} is specified, X-13ARIMA-SEATS automatically tests the data
to determine the most appropriate transformation.

{dlgtab:Output Variables}

{phang}
{opt saving(name)} specifies the name for the seasonally adjusted series.
Default is {it:varname}_sa.

{phang}
{opt trend(name)} saves the trend-cycle component with the specified name.

{phang}
{opt irregular(name)} saves the irregular component with the specified name.

{phang}
{opt sfactor(name)} saves the seasonal factors with the specified name.

{dlgtab:File Management}

{phang}
{opt workdir(string)} specifies the directory where temporary files will be created.
Default is Stata's temporary directory.

{phang}
{opt keepfiles} preserves X-13 specification (.spc) and output files after
execution. By default, these files are deleted. Use this option for debugging
or to examine X-13's detailed output.

{phang}
{opt replace} allows overwriting existing variables. Without this option,
the command will refuse to replace existing variables.

{phang}
{opt details} displays the X-13 specification file and shows execution details.
Useful for understanding what X-13 is doing or for debugging.


{marker examples}{...}
{title:Examples}

{pstd}Setup{p_end}
{phang2}{cmd:. webuse gnp96}{p_end}
{phang2}{cmd:. tsset}{p_end}

{pstd}Basic seasonal adjustment (SEATS with defaults){p_end}
{phang2}{cmd:. x13as gnp96}{p_end}

{pstd}SEATS adjustment with all components{p_end}
{phang2}{cmd:. x13as gnp96, trend(gnp96_tr) irregular(gnp96_ir) sfactor(gnp96_sf)}{p_end}

{pstd}X-11 with automatic transformation{p_end}
{phang2}{cmd:. x13as gnp96, method(x11)}{p_end}

{pstd}SEATS with no transformation (additive){p_end}
{phang2}{cmd:. x13as gnp96, transform(none)}{p_end}

{pstd}SEATS with log transformation (multiplicative){p_end}
{phang2}{cmd:. x13as gnp96, transform(log)}{p_end}

{pstd}X-11 without transformation (additive){p_end}
{phang2}{cmd:. x13as gnp96, method(x11) transform(none)}{p_end}

{pstd}X-11 with log transformation (multiplicative){p_end}
{phang2}{cmd:. x13as gnp96, method(x11) transform(log)}{p_end}

{pstd}Custom variable names{p_end}
{phang2}{cmd:. x13as gnp96, saving(gnp_adj) trend(gnp_trend)}{p_end}

{pstd}Replace existing variables{p_end}
{phang2}{cmd:. x13as gnp96, replace}{p_end}

{pstd}Show execution details{p_end}
{phang2}{cmd:. x13as gnp96, details}{p_end}

{pstd}Keep temporary files for inspection{p_end}
{phang2}{cmd:. x13as gnp96, keepfiles workdir("C:/temp")}{p_end}

{pstd}Process multiple series{p_end}
{phang2}{cmd:. foreach var of varlist gdp consumption investment {c -(}}{p_end}
{phang2}{cmd:.     x13as `var', replace}{p_end}
{phang2}{cmd:. {c )-}}{p_end}


{marker results}{...}
{title:Stored results}

{pstd}
{cmd:x13as} stores the following in {cmd:r()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Scalars}{p_end}
{synopt:{cmd:r(N)}}number of observations used{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Macros}{p_end}
{synopt:{cmd:r(method)}}decomposition method (seats or x11){p_end}
{synopt:{cmd:r(transform)}}transformation applied (auto, none, or log){p_end}
{synopt:{cmd:r(saving)}}name of seasonally adjusted variable{p_end}
{synopt:{cmd:r(trend)}}name of trend variable (if saved){p_end}
{synopt:{cmd:r(irregular)}}name of irregular variable (if saved){p_end}
{synopt:{cmd:r(sfactor)}}name of seasonal factor variable (if saved){p_end}
{synopt:{cmd:r(workdir)}}working directory path{p_end}
{synopt:{cmd:r(fileprefix)}}prefix of temporary files{p_end}


{marker technical}{...}
{title:Technical Notes}

{pstd}
{bf:Requirements:}

{phang2}• X-13ARIMA-SEATS must be installed and the x13as.exe executable file should be in C:\x13as{p_end}
{phang2}• Data must be declared as time series using {cmd:tsset}{p_end}
{phang2}• Data must be monthly or quarterly{p_end}
{phang2}• Minimum of 3 years of data recommended{p_end}

{pstd}
{bf:Specifications:}

{pstd}
The command generates X-13 specification files based on the combination of
{bf:method} and {bf:transform} options. All specifications include:

{phang2}• regression{c -(} aictest = (td easter) {c )-}{p_end}
{phang2}• automdl{c -(}{c )-}{p_end}
{phang2}• outlier{c -(}{c )-}{p_end}

{pstd}
{ul:Transform specification:}

{phang2}• When {bf:transform=auto} (default): No transform block is written; X-13 automatically determines the transformation{p_end}
{phang2}• When {bf:transform=none}: transform{c -(} function = none {c )-}{p_end}
{phang2}• When {bf:transform=log}: transform{c -(} function = log {c )-}{p_end}

{pstd}
{ul:Method specification:}

{phang2}• When {bf:method=seats} (default): seats{c -(} noadmiss = yes  save = (s11 s12 s13 s16) {c )-}{p_end}
{phang2}• When {bf:method=x11}: x11{c -(} save = (d11 d12 d13 d16) {c )-}{p_end}

{pstd}
{bf:Example combinations:}

{phang2}1. {cmd:x13as myvar} (default: SEATS with transform=auto){p_end}
{phang2}2. {cmd:x13as myvar, method(x11)} (X-11 with transform=auto){p_end}
{phang2}3. {cmd:x13as myvar, transform(none)} (SEATS with no transformation){p_end}
{phang2}4. {cmd:x13as myvar, method(x11) transform(log)} (X-11 with log transformation){p_end}

{pstd}
{bf:Output files:}

{phang2}• s11/d11: Seasonally adjusted series{p_end}
{phang2}• s12/d12: Trend-cycle component{p_end}
{phang2}• s13/d13: Irregular component{p_end}
{phang2}• s16/d16: Seasonal factors{p_end}

{pstd}
{bf:Calendar effects:}

{pstd}
The command automatically tests for trading day and Easter effects using
X-13's {bf:aictest} option. If these effects are statistically significant,
they are included in the model. If not, they are excluded. This is done
automatically without user intervention.

{pstd}
{bf:Outlier detection:}

{pstd}
Version 5.2 adds automatic outlier detection using X-13's {bf:outlier} spec.
This automatically identifies and adjusts for additive outliers (AO), level
shifts (LS), and temporary changes (TC) in the time series. The outliers are
detected and estimated as part of the regARIMA model, improving the quality
of the seasonal adjustment.


{marker references}{...}
{title:References}

{phang}
U.S. Census Bureau. 2017. {it:X-13ARIMA-SEATS Reference Manual}.
https://www.census.gov/srd/www/x13as/


{title:Author}

{pstd}
x13as.ado version 5.2 (simplified){break}
Jed Kolko, with heavy assists from Claude and ChatGPT{break}
questions and feedback: www.jedkolko.com/contact{break}
November 2025


{title:Also see}

{psee}
Online:  {helpb tssmooth}, {helpb arima}, {helpb ucm}
{p_end}
